/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************

   Here we'll present how to properly use different camera modes

/******************************************************************************/
// Define viewing modes:
enum VIEW_MODE // Viewing Mode
{
   VIEW_FPP, // First Person
   VIEW_TPP, // Third Person
   VIEW_ISO, // Isometric
   VIEW_NUM, // number of view modes
};
U32 View; // current VIEW_MODE
/******************************************************************************/
struct Player : Game::Chr
{
   virtual Bool update();
   
   virtual void draw(); // extend drawing to disable head rendering in FPP mode
};
/******************************************************************************/
Game::ObjMemx<Game::Static> Statics; // container for static objects
Game::ObjMemx<Game::Item  > Items  ; // container for item   objects
Game::ObjMemx<      Player> Players; // container for player objects
/******************************************************************************/
Bool Player::update()
{
   if(action)
   {
      if(Kb.b(KB_W) || Kb.b(KB_S) || Kb.b(KB_A) || Kb.b(KB_D) || Kb.b(KB_Q) || Kb.b(KB_E))actionBreak();
   }

   if(!action)
   {
      // turn & move
      input.anglei.x=Kb.b(KB_Q)-Kb.b(KB_E);
      input.anglei.y=Kb.b(KB_T)-Kb.b(KB_G);
      input.diri  .x=Kb.b(KB_D)-Kb.b(KB_A);
      input.diri  .z=Kb.b(KB_W)-Kb.b(KB_S);
      input.diri  .y=Kb.b(KB_SPACE)-Kb.b(KB_LSHIFT);

      // dodge, crouch, walk, jump
      input.dodge = Kb.bd(KB_D)-Kb.bd(KB_A);
      input.crouch= Kb.b (KB_LSHIFT);
      input.walk  = Kb.b (KB_LCTRL );
      input.jump  =(Kb.bp(KB_SPACE ) ? 3.5 : 0);

      // mouse turn
      if(View!=VIEW_ISO) // don't use mouse turning when in Isometric mode
      {
         Flt max=DegToRad(900)*Tm.d,
             dx =Ms.dir_ds.x*1.7,
             dy =Ms.dir_ds.y*1.7*Ms.inv();
         angle.x-=Mid(dx,-max,max);
         angle.y+=Mid(dy,-max,max);
      }

      // ready stance change
      ready^=Kb.bp(KB_R);
   }

   return __super::update();
}

void Player::draw()
{
   Bool disable_head_draw=(View==VIEW_FPP && Renderer()!=RM_SHD_MAP && mesh); // disable drawing head when we're in FPP mode and we're not in shadowing mode (if this isn't included player will cast head-less shadows)

   if(disable_head_draw)mesh->hide("head"); // hide "head" mesh part in 'mesh'

   __super::draw(); // call default drawing

   if(disable_head_draw)mesh->show("head"); // un-hide "head" mesh part, so other objects which use the same mesh will have the head rendered properly
}
/******************************************************************************/
void InitPre()
{
   App.name="Camera Modes";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).ambPower(0.3).hpRt(true);
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sky    .set   ();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower();
   Sun.rays.mode=SUN_RAYS_HIGH;

   // create the world
   Game::World.init()
              .setType(Statics,OBJ_STATIC)
              .setType(Players,OBJ_CHR   )
              .setItem(Items  ,OBJ_ITEM  )
              .New("world/sample"        );

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Game::World.update(Cam.at);

   // set next camera mode when Tab pressed
   if(Kb.bp(KB_TAB))
   {
      View=(View+1)%VIEW_NUM;

      if(View==VIEW_ISO) // when set to isometric view
      {
         Cam.dist =   10; // set bigger camera distance at start
         Cam.pitch=-PI_4; // set starting camera pitch angle
      }
   }

   // setup the camera
   if(Players.elms()) // if we have at least one player
   {
      // set camera depending on current view mode
      switch(View)
      {
         case VIEW_FPP:
         {
            OrientP &head=Players[0].cskel.getPoint("head"); // obtain player "head" skeleton point (this was created in Mesh Editor)
            Cam.setPosDir(head.pos,head.dir,head.perp); // set camera from 'head' position, direction and perpendicular to direction
         }break;
         
         case VIEW_TPP:
         {
            Cam.dist=Max(1.0f,Cam.dist*ScaleMul(Ms.wheel*-0.1)); // update camera distance according to mouse wheel
            Cam.setSpherical(Players[0].pos()+Vec(0,0.5,0), Players[0].angle.x, Players[0].angle.y, 0, Cam.dist); // set spherical camera looking at player position with given player angles
         }break;
         
         default: // VIEW_ISO
         {
            Cam.yaw  -=Ms.ds.x; // update camera yaw   angle according to mouse smooth delta x
            Cam.pitch+=Ms.ds.y; // update camera pitch angle according to mouse smooth delta y
            Clamp(Cam.pitch,-PI_2,0); // clamp to possible camera pitch angle
            Cam.dist  =Max(1.0f,Cam.dist*ScaleMul(Ms.wheel*-0.1)); // update camera distance according to mouse wheel
            Cam.setSpherical(Players[0].pos(), Cam.yaw, Cam.pitch, 0, Cam.dist); // set spherical camera looking at player using camera angles
         }break;
      }

      // after setting camera position and angles:
      Cam.updateVelocities().set(); // update camera velocities and activate it
   }
   else // when no player on the scene
   {
      CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // default camera handling actions
   }

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);
   D.text  (0,0.9,"Press Tab to switch camera modes");
}
/******************************************************************************/
